/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.GenericDataPoint;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.DatabaseInfo;
import ibm.nways.analysis.dpManager.DatabaseWorker;
import ibm.nways.analysis.dpManager.SeparatorUtil;
import ibm.nways.analysis.dpManager.VectorUtil;
import ibm.nways.analysis.dpManager.dpServerImpl;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;

public class DatabaseConnection
extends DatabaseInfo
implements AppletNotifyInterface {
    public static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private String createIndexTable;
    public dpServerImpl refServer;
    private Vector eventVector;
    private Vector instanceVector;
    private Vector workVector;
    private DatabaseWorker theWorker;
    private Connection con;
    private int maxSQLLength;
    private boolean isAccess = false;
    private static final long N_HOURS = 0x6DDD00L;
    private static final int MAX_QUEUE_SIZE = 500;
    static final String HOST_INDEX = adminRB.getString("s_HOST_INDEX");
    static final String IP_ADDRESS = adminRB.getString("s_IP_ADDRESS");
    static final String POD_IDENTIFIER = adminRB.getString("s_POD_IDENTIFIER");
    static final String DATA_TABLE_KEY = adminRB.getString("s_DATA_TABLE_KEY");
    static final String POL_EVENT_DATA = adminRB.getString("s_POL_EVENT_DATA");
    static final String HOSTNAME = adminRB.getString("s_HOSTNAME");
    static final String EVENT_NAME = adminRB.getString("s_EVENT_NAME");
    static final String CAUSE = adminRB.getString("s_CAUSE");
    static final String ACQUIRED_TIME = adminRB.getString("s_ACQUIRED_TIME");
    static final String MIB_INDEX = adminRB.getString("s_MIB_INDEX");
    static final String EVENT_VALUE = adminRB.getString("s_EVENT_VALUE");
    static final String POI_KEY = adminRB.getString("s_POI_KEY");
    static final String RES_EVENT_DATA = adminRB.getString("s_RES_EVENT_DATA");
    static final String ACQUIRED_VALUE = adminRB.getString("s_ACQUIRED_VALUE");
    static final String APP_TIME = "APP_TIME";
    private static String ACCESS = "ACCESS";

    public void logMessage(String string, Exception exception) {
        if (exception != null) {
            exception.printStackTrace();
        }
        dpServerImpl.DM((String)string, (Exception)exception);
    }

    public void logMessage(String string) {
        this.logMessage(string, null);
    }

    public static void logError(String string, Exception exception) {
        if (string != null) {
            dpServerImpl.DM((String)string, (Exception)exception);
        }
    }

    public DatabaseConnection(DatabaseInfo databaseInfo, dpServerImpl dpServerImpl2) throws ClassNotFoundException, RemoteException, SQLException {
        super(databaseInfo);
        this.refServer = dpServerImpl2;
        try {
            Class.forName(this.getDriverName()).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        this.eventVector = new Vector();
        this.instanceVector = new Vector();
        this.workVector = new Vector();
        if (this.authInfoExist()) {
            this.logMessage("Using : " + this.getUserId() + " and " + this.getPassword());
            this.con = DriverManager.getConnection(this.getDatabaseURL(), this.getUserId(), this.getPassword());
        } else {
            this.con = DriverManager.getConnection(this.getDatabaseURL());
        }
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        if (databaseMetaData.getDatabaseProductName().equals(ACCESS)) {
            this.isAccess = true;
        }
        this.maxSQLLength = databaseMetaData.getMaxStatementLength() / 2;
        this.createIndexTable = new String("CREATE TABLE " + HOST_INDEX + " (" + IP_ADDRESS + " VARCHAR(254) NOT NULL, " + POD_IDENTIFIER + " VARCHAR(254) NOT NULL, " + DATA_TABLE_KEY + " INTEGER)");
        String string = new String("CREATE TABLE " + POL_EVENT_DATA + " (" + HOSTNAME + " VARCHAR(254), " + EVENT_NAME + " VARCHAR(254), " + CAUSE + " VARCHAR(254), " + ACQUIRED_TIME + " VARCHAR(254) NOT NULL, " + APP_TIME + " DOUBLE PRECISION," + MIB_INDEX + " VARCHAR(254), " + EVENT_VALUE + " DOUBLE PRECISION, " + POI_KEY + " VARCHAR(254))");
        String string2 = new String("CREATE TABLE " + RES_EVENT_DATA + " (" + HOSTNAME + " VARCHAR(254), " + EVENT_NAME + " VARCHAR(254), " + CAUSE + " VARCHAR(254), " + ACQUIRED_TIME + " VARCHAR(254) NOT NULL, " + APP_TIME + " DOUBLE PRECISION)");
        Statement statement = this.con.createStatement();
        try {
            if (!this.tableExist(HOST_INDEX) && statement.execute(this.createIndexTable)) {
                this.logMessage("DatabaseConnection:error creating host index table");
            }
            if (!this.tableExist(POL_EVENT_DATA) && statement.execute(string)) {
                this.logMessage("DatabaseConnection:error creating Polling Event table");
            }
            if (!this.tableExist(RES_EVENT_DATA) && statement.execute(string2)) {
                this.logMessage("DatabaseConnection:error creating Resource Event table");
            }
        }
        catch (SQLException sQLException) {
            this.logMessage("DatabaseConnection:  caught table create exception since some db's don't support table catalog", sQLException);
        }
        EventFilter eventFilter = new EventFilter(new Integer(3), null, null);
        if (dpServerImpl2 != null) {
            dpServerImpl2.registerForEvents((AppletNotifyInterface)this, eventFilter);
        }
        statement.close();
        this.theWorker = new DatabaseWorker(this);
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean isAccess() {
        return this.isAccess;
    }

    public int getMaxSQL() {
        return this.maxSQLLength;
    }

    public void updateEvent(Vector vector) {
        this.insertDatabaseWork(vector);
    }

    public synchronized Object getNextWork() {
        Object var1_1 = null;
        while (this.workVector.size() < 1) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                this.logMessage("DatabaseConnection:getNextWork:exception occurred", exception);
            }
        }
        var1_1 = this.workVector.firstElement();
        this.workVector.removeElementAt(0);
        return var1_1;
    }

    public synchronized void insertDatabaseWork(Object object) {
        if ((double)this.workVector.size() > 400.0) {
            this.logMessage("Warning:  Queue size is becoming very large!!" + this.workVector.size());
            DatabaseConnection.logError("Warning:  Queue size is becoming very large!! " + this.workVector.size(), null);
        }
        this.workVector.addElement(object);
        this.notify();
    }

    public synchronized int createNewTable(PollingObjectInstance pollingObjectInstance) {
        int n = 1;
        String string = null;
        String string2 = null;
        try {
            String string3 = new String("SELECT MAX(" + DATA_TABLE_KEY + ") FROM " + HOST_INDEX);
            ResultSet resultSet = null;
            Statement statement = this.getConnection().createStatement();
            resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt(1) + 1;
            }
            resultSet.close();
            statement.close();
            string = new String("CREATE TABLE D" + Integer.toString(n) + " (" + MIB_INDEX + " VARCHAR(254) ," + ACQUIRED_TIME + " VARCHAR(254) NOT NULL , " + ACQUIRED_VALUE + " DOUBLE PRECISION , " + APP_TIME + " DOUBLE PRECISION)");
            Statement statement2 = this.getConnection().createStatement();
            if (statement2.execute(string)) {
                this.logMessage("DatabaseConnection:createNewTable:table creation error");
            }
            statement2.close();
            string2 = new String("INSERT INTO " + HOST_INDEX + " VALUES ('" + pollingObjectInstance.getHostname() + "' , '" + pollingObjectInstance.getIdentifier() + "' , " + Integer.toString(n) + ")");
            Statement statement3 = this.getConnection().createStatement();
            statement3.executeUpdate(string2);
            statement3.close();
        }
        catch (Exception exception) {
            DatabaseConnection.logError(String.valueOf(string) + "\n\n" + string2, exception);
            DatabaseConnection.logError(String.valueOf(string) + "\n\n" + string2, exception);
        }
        return n;
    }

    public int getDataKey(String string, String string2) {
        String string3 = new String("SELECT * FROM " + HOST_INDEX + " WHERE (" + IP_ADDRESS + " = '" + string2 + "' ) AND ( " + POD_IDENTIFIER + " = '" + string + "' )");
        int n = -1;
        try {
            Statement statement = this.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            if (resultSet.next()) {
                n = resultSet.getInt(3);
            }
            resultSet.close();
            statement.close();
            Runtime.getRuntime().runFinalization();
        }
        catch (Exception exception) {
            DatabaseConnection.logError("", exception);
        }
        return n;
    }

    public Vector getPollingObjectInstanceIndices(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = this.getDataKey(string, string2);
        if (n != -1) {
            try {
                Statement statement = this.getConnection().createStatement();
                String string3 = new String("SELECT DISTINCT MIB_INDEX FROM D" + n);
                ResultSet resultSet = statement.executeQuery(string3);
                vector = new Vector();
                while (resultSet.next()) {
                    String string4 = resultSet.getString(1);
                    if (string4.equals("0")) continue;
                    vector.addElement(string4);
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                DatabaseConnection.logError("", exception);
            }
        }
        if (vector != null && vector.size() == 0) {
            vector = null;
        }
        return vector;
    }

    public void testGetString() {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            String string = new String("SELECT * FROM D1");
            block2: while (true) {
                resultSet = statement.executeQuery(string);
                while (true) {
                    if (!resultSet.next()) continue block2;
                    System.out.println(resultSet.getString(1));
                }
                break;
            }
        }
        catch (Exception exception) {
            DatabaseConnection.logError("", exception);
            return;
        }
    }

    public Hashtable getHistory(PollingObjectInstance pollingObjectInstance, long l, long l2, Vector vector) throws SQLException {
        Object object;
        Hashtable hashtable = new Hashtable();
        Date date = new Date(0, 0, 0);
        date.setTime(l);
        Time time = new Time(0, 0, 0);
        time.setTime(l);
        String string = date.toString();
        String string2 = time.toString();
        date.setTime(l2);
        time.setTime(l2);
        String string3 = date.toString();
        String string4 = time.toString();
        String string5 = new String(String.valueOf(string) + "," + string2);
        String string6 = new String(String.valueOf(string3) + "," + string4);
        int n = this.getDataKey(pollingObjectInstance.getIdentifier(), pollingObjectInstance.getHostname());
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
        }
        catch (Exception exception) {
            DatabaseConnection.logError("", exception);
        }
        if (n != -1) {
            object = new String("SELECT * FROM D" + n + " WHERE ( ");
            if (vector != null && vector.size() > 0) {
                object = String.valueOf(object) + " ( ";
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = String.valueOf(object) + " (" + MIB_INDEX + " = '" + (String)enumeration.nextElement() + "') ";
                    object = enumeration.hasMoreElements() ? String.valueOf(object) + " OR " : String.valueOf(object) + ") AND ";
                }
            }
            object = String.valueOf(object) + " (" + ACQUIRED_TIME + " BETWEEN '" + string5 + "' AND '" + string6 + "')) ORDER BY " + ACQUIRED_TIME + " ASC";
            try {
                resultSet = statement.executeQuery((String)object);
                hashtable = SeparatorUtil.separateData(null, resultSet, pollingObjectInstance, l, l2);
            }
            catch (Exception exception) {
                DatabaseConnection.logError("", exception);
            }
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        object = this;
        synchronized (object) {
            Enumeration enumeration = this.workVector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof PollingObjectInstance) {
                    dpServerImpl.DM((String)(String.valueOf(((PollingObjectInstance)e).getHostname()) + " : " + ((PollingObjectInstance)e).getIdentifier()));
                }
                if (!(e instanceof PollingObjectInstance) || !e.equals(pollingObjectInstance)) continue;
                PollingObjectInstance pollingObjectInstance2 = (PollingObjectInstance)e;
                dpServerImpl.DM((String)(String.valueOf(pollingObjectInstance2.getHostname()) + " : " + pollingObjectInstance2.getIdentifier()));
                hashtable = SeparatorUtil.separateData(hashtable, pollingObjectInstance2, l, l2);
            }
        }
        return hashtable;
    }

    private String filterToSQL(EventFilter eventFilter) {
        CharSequence charSequence;
        String string;
        Date date = new Date(0, 0, 0);
        Time time = new Time(0, 0, 0);
        String string2 = null;
        if (eventFilter.getBeginTime() > -1L) {
            date.setTime(eventFilter.getBeginTime());
            time.setTime(eventFilter.getBeginTime());
            string = date.toString();
            charSequence = time.toString();
            string2 = new String(String.valueOf(string) + "," + (String)charSequence);
        }
        string = null;
        if (eventFilter.getEndTime() > -1L) {
            date.setTime(eventFilter.getEndTime());
            time.setTime(eventFilter.getEndTime());
            charSequence = date.toString();
            String string3 = time.toString();
            string = new String(String.valueOf(charSequence) + "," + string3);
        }
        charSequence = new StringBuffer();
        if (string2 != null || string != null || eventFilter.getHostname() != null || eventFilter.getEventName() != null || eventFilter.getResourceManager() != null) {
            ((StringBuffer)charSequence).append(" WHERE ");
            boolean bl = false;
            if (string2 != null && string != null) {
                ((StringBuffer)charSequence).append("(" + ACQUIRED_TIME + " BETWEEN '" + string2);
                ((StringBuffer)charSequence).append("' AND '" + string + "')");
                bl = true;
            } else if (string2 != null) {
                ((StringBuffer)charSequence).append("(" + ACQUIRED_TIME + " > '" + string2 + "')");
                bl = true;
            } else if (string != null) {
                ((StringBuffer)charSequence).append(" (" + ACQUIRED_TIME + " > '" + string + "')");
                bl = true;
            }
            if (eventFilter.getPOIIndex() != -1L) {
                if (bl) {
                    ((StringBuffer)charSequence).append(" AND ");
                }
                ((StringBuffer)charSequence).append(" (" + POI_KEY + " = '" + eventFilter.getPOIIndex() + "')");
                bl = true;
                if (eventFilter.getIndexString() != null) {
                    if (bl) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append(" (" + MIB_INDEX + " ='" + eventFilter.getIndexString() + "')");
                    bl = true;
                }
            } else {
                if (eventFilter.getHostname() != null) {
                    if (bl) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append("(" + HOSTNAME + " = '" + eventFilter.getHostname() + "')");
                    bl = true;
                }
                if (eventFilter.getEventName() != null) {
                    if (bl) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append("(" + EVENT_NAME + " = '" + eventFilter.getEventName() + "')");
                    bl = true;
                }
                if (eventFilter.getResourceManager() != null) {
                    if (bl) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append("(" + HOSTNAME + " = '" + eventFilter.getResourceManager().dpGetHostname() + "')");
                    bl = true;
                }
                if (eventFilter.getIndexString() != null) {
                    if (bl) {
                        ((StringBuffer)charSequence).append(" AND ");
                    }
                    ((StringBuffer)charSequence).append(" (" + MIB_INDEX + " ='" + eventFilter.getIndexString() + "')");
                    bl = true;
                }
            }
        }
        if (((StringBuffer)charSequence).toString().length() > 0) {
            ((StringBuffer)charSequence).append(" ORDER BY " + ACQUIRED_TIME + " ASC");
        }
        return ((StringBuffer)charSequence).toString();
    }

    public void clearEvent(PerformanceEvent performanceEvent) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM");
        if (performanceEvent.getEventType() == 64) {
            stringBuffer.append(" " + POL_EVENT_DATA + " ");
            stringBuffer.append("WHERE ( (" + HOSTNAME + " = '" + performanceEvent.getHostname() + "') AND ");
            stringBuffer.append("(" + EVENT_NAME + " = '" + performanceEvent.getIdentifier() + "') AND ");
            stringBuffer.append("(" + CAUSE + " = '" + PerformanceEvent.toString(performanceEvent.getCause()) + "') AND ");
            object = performanceEvent.getDataPoint();
            if (object != null && ((GenericDataPoint)object).getID() != null) {
                stringBuffer.append("(" + MIB_INDEX + " = '" + ((GenericDataPoint)object).getID() + "') AND ");
            } else {
                stringBuffer.append("(" + MIB_INDEX + " = '0') AND ");
            }
            stringBuffer.append("(" + ACQUIRED_TIME + " = " + DatabaseConnection.processTime(performanceEvent.getEventTime()) + ") AND ");
            stringBuffer.append("(APP_TIME = " + Double.toString(performanceEvent.getEventTime()) + ") AND ");
            stringBuffer.append("(" + EVENT_VALUE + " = " + Double.toString(((DataPoint)object).getValue()) + ") )");
        } else if (performanceEvent.getEventType() == 32) {
            stringBuffer.append(" " + RES_EVENT_DATA + " ");
            stringBuffer.append("WHERE ( (" + HOSTNAME + " = '" + performanceEvent.getHostname() + "') AND ");
            stringBuffer.append("(" + EVENT_NAME + " = '" + performanceEvent.getIdentifier() + "') AND ");
            stringBuffer.append("(" + CAUSE + " = '" + PerformanceEvent.toString(performanceEvent.getCause()) + "') AND ");
            stringBuffer.append("(APP_TIME = " + Double.toString(performanceEvent.getEventTime()) + ") AND ");
            stringBuffer.append("(" + ACQUIRED_TIME + " = " + DatabaseConnection.processTime(performanceEvent.getEventTime()) + ") )");
        }
        try {
            object = this.getConnection().createStatement();
            int n = object.executeUpdate(stringBuffer.toString());
            DatabaseConnection.logError("DatabaseConnection :  resultSet returned " + n, null);
            object.close();
            return;
        }
        catch (SQLException sQLException) {
            DatabaseConnection.logError("Clear Events", sQLException);
            return;
        }
    }

    public Vector getEvents(EventFilter eventFilter) {
        StringBuffer stringBuffer;
        Vector vector = null;
        Vector vector2 = null;
        if ((eventFilter.getCauseMask() & 0x40) != 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * FROM " + POL_EVENT_DATA);
            stringBuffer.append(this.filterToSQL(eventFilter));
            vector = this.processQuery(stringBuffer.toString(), eventFilter, true);
        }
        if ((eventFilter.getCauseMask() & 0x20) != 0) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("SELECT * FROM " + RES_EVENT_DATA);
            stringBuffer.append(this.filterToSQL(eventFilter));
            vector2 = this.processQuery(stringBuffer.toString(), eventFilter, false);
            if (vector2 != null) {
                this.logMessage("Returning " + vector2.size() + " resource events from the database");
            } else {
                this.logMessage("No resource events returned");
            }
        }
        return VectorUtil.unionOfTwoVectors(vector, vector2);
    }

    public static String processTime(long l) {
        Date date = new Date(0, 0, 0);
        Time time = new Time(0, 0, 0);
        date.setTime(l);
        time.setTime(l);
        return new String("'" + date.toString() + "," + time.toString() + "'");
    }

    public static java.util.Date processTime(String string) {
        String string2 = string.substring(0, string.indexOf(44));
        String string3 = string.substring(string.indexOf(44) + 1);
        Date date = Date.valueOf(string2);
        Time time = Time.valueOf(string3);
        java.util.Date date2 = new java.util.Date(date.getTime() + time.getTime() + (long)TimeZone.getDefault().getRawOffset());
        return date2;
    }

    private synchronized Vector processQuery(String string, EventFilter eventFilter, boolean bl) {
        Vector<PerformanceEvent> vector = new Vector<PerformanceEvent>();
        try {
            Statement statement = this.getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                int n = PerformanceEvent.toInt(resultSet.getString(3));
                long l = (long)resultSet.getDouble(5);
                PerformanceEvent performanceEvent = null;
                if (bl) {
                    String string4 = resultSet.getString(6);
                    DataPoint dataPoint = null;
                    dataPoint = string4.equals("0") ? new DataPoint(l, null, (float)resultSet.getDouble(7)) : new DataPoint(l, string4, (float)resultSet.getDouble(7));
                    Vector<DataPoint> vector2 = new Vector<DataPoint>();
                    vector2.addElement(dataPoint);
                    long l2 = Long.parseLong(resultSet.getString(8));
                    performanceEvent = new PerformanceEvent(n, string2, string3, vector2, l2, l);
                } else {
                    performanceEvent = new PerformanceEvent(n, string2, string3, l);
                }
                if (!eventFilter.filter(performanceEvent, this.refServer)) continue;
                vector.addElement(performanceEvent);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            this.logMessage("DatabaseConnection:ProcessQuery", sQLException);
        }
        catch (NumberFormatException numberFormatException) {
            this.logMessage("DatabaseConnection:ProcessQuery", numberFormatException);
        }
        return vector;
    }

    private boolean tableExist(String string) {
        boolean bl = false;
        try {
            ResultSet resultSet = this.getConnection().getMetaData().getTables("", "", string, null);
            bl = resultSet.next();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            this.logMessage("Cannot tell if table : " + string + " exists or driver must not be capable:");
            DatabaseConnection.logError("", sQLException);
        }
        return bl;
    }

    public void close() throws SQLException, RemoteException {
        if (this.theWorker != null) {
            this.theWorker.stop();
            this.theWorker = null;
        }
        if (this.con != null) {
            DatabaseConnection.logError("Closing Database connection.", null);
            this.con.close();
        }
        if (this.refServer != null) {
            this.refServer.unregisterForEvents((AppletNotifyInterface)this);
        }
    }

    public static void main(String[] stringArray) {
        DatabaseInfo databaseInfo = new DatabaseInfo();
        DatabaseConnection databaseConnection = null;
        try {
            databaseConnection = new DatabaseConnection(databaseInfo, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            int n = 0;
            while (n < 10) {
                int n2 = 0;
                while (n2 < 10) {
                    int n3 = 0;
                    while (n3 < 1) {
                        String string = String.valueOf(Integer.toString(n)) + "." + Integer.toString(n2) + "." + Integer.toString(n3);
                        PollingObjectInstance pollingObjectInstance = new PollingObjectInstance(string, "identifier", new Vector(), System.currentTimeMillis());
                        Hashtable hashtable = databaseConnection.getHistory(pollingObjectInstance, 0L, System.currentTimeMillis(), null);
                        System.out.println(hashtable);
                        System.out.println("Hashtable size is: " + hashtable.size());
                        if (hashtable != null) {
                            Enumeration enumeration = hashtable.keys();
                            while (enumeration.hasMoreElements()) {
                                String cfr_ignored_0 = (String)enumeration.nextElement();
                            }
                            System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
                            System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

